rm(list = ls())

shinyUI(pageWithSidebar(

	headerPanel("Prior Specification"),
	
	sidebarPanel(
	
		helpText("Before any data are observed, please answer the following questions to specify your prior distributions. "),
		br(),
		
		textInput("expert", "Expert's name: ", ""),
		br(),
		br(),
		
		helpText("First consider the group of patients eligible for inclusion in the MYCYC trial and the group eligible for the MYPAN trial: "),
		br(),
				
		sliderInput(inputId = "lambdaC_q1",
				label = "Q1: What is the chance that the 6-month remission rate on CYC/steroids in the MYCYC patient group exceeds that in the MYPAN patient group?",
				min = 0, max = 1, value = 0.5, step=0.05),
		br(),
		br(),		
		sliderInput(inputId = "lambdaC_q2",
				label = "Q2: What is the chance that the 6-month remission rate on CYC/steroids in the MYPAN patient group exceeds that in the MYCYC patient group by more than 10%?",
				min = 0, max=1, value = 0.5, step=0.05),
		br(),
		br(),
		sliderInput(inputId = "lambdaE_q1",
				label = "Q3: What is the chance that the 6-month remission rate on MMF/steroids in the MYCYC patient group exceeds that in the MYPAN patient group?",
				min = 0, max = 1, value = 0.5, step=0.05),
		br(),
		br(),		
		sliderInput(inputId = "lambdaE_q2",
				label = "Q4: What is the chance that the 6-month remission rate on MMF/steroids in the MYPAN patient group exceeds that in the MYCYC patient group by more than 10%?",
				min = 0, max=1, value = 0.5, step=0.05),
		br(),
		br(),	
		checkboxInput(inputId = "nomycyc", 
					label = strong("Discard MYCYC data from prior distributions. "),
					value = FALSE),
        br(),
        br(),
		br(),
				
		checkboxInput(inputId = "posterior40", 
					label = strong("Update prior distributions with a hypothetical MYPAN trial dataset on 40 patients "),
					value = FALSE),
		checkboxInput(inputId = "posterior20", 
					label = strong("Update prior distributions with a hypothetical MYPAN trial dataset on 20 patients "),
					value = FALSE),

	## Output two tabs: one to plot the density of the (prior/posterior) distribution
	## and one to summarise the (prior/posterior) distribution
	
	br(),				
	## Display this only if data are available to update the prior distribution				
	conditionalPanel(condition = "input.posterior40 == true & input.posterior20 == false",
			numericInput(inputId = "n_cyc40", label = "Number randomized to CYC (out of 40 patients)", value=20, min = 1, max= 40,  step=1),
			br(),
			numericInput(inputId = "cyc_succ40", label = "Number of successes on CYC:", value=14, min = 0, max = 40, step =1),
			br(),
			br(),
			helpText("For the remaining patients randomized to MMF: "),
			numericInput(inputId = "mmf_succ40", label = "Number of successes on MMF:", value=14, min = 0, step=1)
	),
	
	conditionalPanel(condition = "input.posterior20 == true & input.posterior40 == false",
			numericInput(inputId = "n_cyc20", label = "Number randomized to CYC (out of 20 patients)", value=10, min = 1, max= 20,  step=1),
			br(),
			numericInput(inputId = "cyc_succ20", label = "Number of successes on CYC:", value=7, min = 0, max = 20, step =1),
			br(),
			br(),
			helpText("For the remaining patients randomized to MMF: "),
			numericInput(inputId = "mmf_succ20", label = "Number of successes on MMF:", value=7, min = 0, step=1)
	),
	
	submitButton("Update Bayesian Distributions")

	),
	
	mainPanel(
		tabsetPanel(
			tabPanel(title = "Summary: MYCYC CYC relevance", h4("Prior density of the log-odds ratio comparing 6 month remission rates on CYC in the MYCYC vs MYPAN trials"), plotOutput(outputId = "lambdaC_density", height="700px")),
			tabPanel(title = "Summary: MYCYC MMF relevance", h4("Prior density of the log-odds ratio comparing 6 month remission rates on MMF in the MYCYC vs MYPAN trials"), plotOutput(outputId = "lambdaE_density", height="700px")),
			tabPanel(title= "MYPAN: CYC Remission Rate", plotOutput(outputId = "pc_density", height="700px")),
			tabPanel(title = "MYPAN: MMF Remission Rate", plotOutput(outputId = "pe_density", height="700px")),
			tabPanel(title = "MYPAN: CYC & MMF Remission", plotOutput(outputId = "pepc_density", height="700px")),
			tabPanel(title = "MYPAN: Log-odds Ratio", plotOutput(outputId = "theta_density", height="700px")),
			tabPanel(title = "Summary: MYPAN treatments", verbatimTextOutput(outputId = "mypan"))
		)
		
	)	
))
	